﻿const { createApp } = Vue;

const app = createApp({
    data() {
        return {
            // 网站信息
            title: '魔云下载站',
            name: '南京兴奈恪科技有限公司陕西分公司',
            icp: '苏ICP备2024122386号',

            // 顶部导航链接
            link1: 'http://sfhu.qpdinm.cn/yyy/',
            link2: 'http://sfhu.qpdinm.cn/yyy/',
            link3: 'http://sfhu.qpdinm.cn/yyy/',
            link4: 'http://sfhu.qpdinm.cn/yyy/',
            link5: 'http://sfhu.qpdinm.cn/yyy/',
            link6: 'http://sfhu.qpdinm.cn/yyy/',
            link7: '',
            link8: '',
            link9: '',
            link10: '',

            // 顶部软件图标
            src1: 'static/images/icon/yyy.svg',
            src2: 'static/images/icon/wsp.jpg',
            src3: 'static/images/icon/aisi.jpg',
            src4: 'static/images/icon/kk.jpg',
            src5: 'static/images/icon/sgsrf.png',
            src6: 'static/images/icon/qishui.webp',
            src7: 'static/images/icon/yd.jpg',
            src8: 'static/images/icon/wyy.jpg',
            src9: 'static/images/icon/xrk.jpg',
            src10: 'static/images/icon/deepl.png',

            // 顶部软件名称
            text1: '易歪歪',
            text2: 'WhatsApp',
            text3: '爱思',
            text4: '夸克',
            text5: '搜狗',
            text6: '汽水音乐',
            text7: '有道翻译',
            text8: '网易云音乐',
            text9: '向日葵',
            text10: 'deepl翻译',

            // 顶部文字按钮隐藏与显示
            distyle0: {
                display: 'block',
                float: 'left'
            },
            distyle1: {
                display: 'none',
                float: 'left'
            },
            distyle2: {
                display: 'none',
                float: 'left'
            },
            distyle3: {
                display: 'none',
                float: 'left'
            },
            distyle4: {
                display: 'none',
                float: 'left'
            },
            distyle5: {
                display: 'none',
                float: 'left'
            },
            distyle6: {
                display: 'none',
                float: 'left'
            },
            distyle7: {
                display: 'none',
                float: 'left'
            },
        }
    },
    mounted() {
        this.loadDependencies();
    },
    methods: {
        loadDependencies() {
            // 按顺序加载依赖
            this.loadScript('static/js/jquery2.1.4.min.js')
                .then(() => this.loadScript('static/js/jquery.superslide.2.1.3.js'))
                .then(() => this.loadScript('static/js/index.js'))
                .then(() => {
                    console.log('所有脚本加载完成');
                    // 这里可以初始化依赖jQuery的插件
                })
                .catch(console.error);
        },
        loadScript(src) {
            return new Promise((resolve, reject) => {
                const script = document.createElement('script');
                script.src = src;
                script.onload = resolve;
                script.onerror = reject;
                document.body.appendChild(script);
            });
        }
    }
});

app.mount('#app');