<?php
// 允许跨域请求（CORS）
header("Access-Control-Allow-Origin: *"); // 替换为你的前端域名
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// 处理 OPTIONS 预检请求（直接返回 200，不重定向）
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// 获取 POST 请求的原始数据
$jsonData = file_get_contents('php://input');
$data = json_decode($jsonData, true);

// 检查是否成功解析 JSON
if ($data && isset($data['url'])) {
    $token = 'YaEiRb0bcCeFTiMf21zMApPAWFUdjs0u@64koJlCWNF4oKDHj1BiTc34NfK6nIJBu';
    $cv = array(
        'logidUrl' => str_replace('\/', '/', $data['url']), // 您的落地页url
        'newType' => 4
    );
    $conversionTypes = array($cv);
    $demo = new APIDemo();
    $result = $demo->sendConvertData($token, $conversionTypes);

    // 返回处理结果给前端
    echo json_encode([
        'status' => $result ? 'success' : 'error',
        'message' => $result ? '数据已提交至百度' : '提交失败',
    ]);
} else {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => '缺少 URL 参数']);
}

/**
 * Class APIDemo API回传数据Demo
 */
class APIDemo {

    const BAIDU_OCPC_URL = 'https://ocpc.baidu.com/ocpcapi/api/uploadConvertData';
    const RETRY_TIMES = 3;

    /**
     * @param $token
     * @param $conversionTypes
     * @return bool 发送成功返回true，失败返回false
     */
    public function sendConvertData($token, $conversionTypes) {
        $reqData = array('token' => $token, 'conversionTypes' => $conversionTypes);
        $reqData = json_encode($reqData, JSON_UNESCAPED_SLASHES);
        // 发送完整的请求数据
        // do some log
        print_r('req data: ' . $reqData . "\n");
        // 向百度发送数据
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_URL, self::BAIDU_OCPC_URL);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $reqData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Content-Length: ' . strlen($reqData)
            )
        );
        // 添加重试，重试次数为3
        for ($i = 0; $i < self::RETRY_TIMES; $i++) {
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($httpCode === 200) {
                // 打印返回结果
                // do some log
                print_r('retry times: ' . $i . ' res: ' . $response . "\n");
                $res = json_decode($response, true);
                // status为4，代表服务端异常，可添加重试
                $status = $res['header']['status'];
                if ($status !== 4) {
                    curl_close($ch);
                    return $status === 0;
                }
            }
        }
        curl_close($ch);
        return false;
    }
}


?>