(function(w) {
    if (w.betterJs) return;
    var config = {};
    w.betterJs = new function () {};
    w.betterJs.config = config;
    w.betterJs.init = function (options) {
        w.betterJs.config.sendError = options.sendError;
        handleWindowError();
        handlePromiseRejection();
        handleResourceError();
        handleAjaxError();
        // handleConsoleError();
    }

    function isFunction(o) {return typeof o === 'function'}
    function errorObject(e) {
        return (e && (typeof e === 'object') && (e.name || e.message || e.stack)) ? {name: e.name, message: e.message, stack: e.stack} : e;
    }
    var handleWindowError = function () {
        var oldError = w.onerror;
        w.onerror = function (msg, url, line, col, error) {
            config.sendError('js', msg, {url: url, line: line, col: col, error: errorObject(error)});
            isFunction(oldError) && oldError.apply(window, arguments);
        }
    }
    // https://developer.mozilla.org/zh-CN/docs/Web/Events/unhandledrejection, no edge support
    var handlePromiseRejection = function () {
        w.addEventListener('unhandledrejection', function (event) {
            event && config.sendError('promise', 'rejected promise', {reason: event.reason});
        }, true);
    }
    var handleResourceError = function () {
        w.addEventListener('error', function (e) {
            var el = e.target || e.srcElement;
            var isRes = el instanceof HTMLScriptElement || el instanceof HTMLLinkElement || el instanceof HTMLImageElement;
            if (!isRes) return; // skip js error
            var url = el.src || el.href;
            config.sendError('resource', 'resource load failed: ' + el.nodeName + ', ' + url,  {nodeName: el.nodeName, url: url, message: e.message, file: e.filename, line: e.lineno, col: e.colno, error: errorObject(e.error)});
        }, true);
    }
    var handleAjaxFetchError = function () {
        if(!w.fetch) return;
        var oldFetch = w.fetch;
        w.fetch = function () {
            var url = arguments[0];
            return oldFetch.apply(this, arguments)
                .then(function (res) {
                    !res.ok && config.sendError('fetch', 'fetch status=' + res.status + ', url=' + url, {url: url, status: res.status});
                    return res;
                }).catch(function (error) {
                    config.sendError('fetch', 'fetch error=' + error.message + ', url=' + url, {error: errorObject(error)});
                    throw error;
                })
        }
    }
    var xhrInsideKey = '_betterJsInside';
    var handleAjaxXhrError = function () {
        if (!w.XMLHttpRequest) return;
        var xhrClass = w.XMLHttpRequest;
        var onXhrEvent = function (event) {
            var xhr = event ? event.currentTarget : null;
            if (xhr.status !== 200) {
                if (this[xhrInsideKey]) {
                    console.log('ignore error inside better-js, xhr status=' + xhr.status + ', url=' + xhr.responseURL, {url: xhr.responseURL, status: xhr.status});
                    return;
                }
                // no responseURL in IE11
                config.sendError('xhr', 'xhr status=' + xhr.status + ', url=' + xhr.responseURL, {url: xhr.responseURL, status: xhr.status});
            }
        }
        var oldSend = xhrClass.prototype.send;
        xhrClass.prototype.send = function () {
            if (this['addEventListener']) {
                this['addEventListener']('error', onXhrEvent);
                this['addEventListener']('load', onXhrEvent);
                this['addEventListener']('abort', onXhrEvent);
            } else {
                var oldStateChange = this['onreadystatechange'];
                this['onreadystatechange'] = function (event) {
                    this.readyState === 4 && onXhrEvent(event);
                    oldStateChange && oldStateChange.apply(this, arguments);
                };
            }
            return oldSend.apply(this, arguments);
        }
    }
    var handleAjaxError = function () {
        if (w.location.protocol === 'file:') return;
        handleAjaxFetchError();
        handleAjaxXhrError();
    }
    w.betterJs.handleConsoleError = function () {
        if (!w.console || !w.console.error) return;
        var oldError = w.console.error;
        w.console.error = function () {
            var a = [];
            for (var i = 0; i < arguments.length; i++) a.push(arguments[i]);
            config.sendError('console', a.join(' '), {args: a});
            oldError && oldError.apply(w, arguments);
        };
    }
    w.betterJs.handleVueError = function () {
        var vue = w.Vue;
        if (!vue || !vue.config) return;
        var oldError = vue.config.errorHandler;
        Vue.config.errorHandler = function VueErrorHandler(error, vm, info) {
            config.sendError('vue', 'vue error: ' + info, {props: vm.$options.props, data: vm.$data, error: errorObject(error)});
            isFunction(oldError) && oldError.call(this, error, vm, info);
        };
    }
    w.betterJs.postJson = function(url, data) {
        var xhr = new XMLHttpRequest();
        xhr[xhrInsideKey] = true;
        xhr.open('POST', url);
        xhr.setRequestHeader('Content-type', 'application/json');
        xhr.send(JSON.stringify(data));
    }
})(window);

window.betterJs.init({
    sendError: function (category, message, data) {
        window.betterJs.postJson('/DataCollector/JsErrorReport', {category: category, message: message, data: data, location: window.location.href, userAgent: navigator.userAgent});
    }
});
