$(() => {
    // nav mobile click
    $('.list-title_click').click(event => {
        showOrCloseClick(event.currentTarget, {
            targetContent: 'list-content',
            imgActive: 'arrow-active',
            targetImg: 'list-title img'
        });
    });

    $('#header-show').click(() => openNavMobile());
    $('#header-close').click(() => closeNavMobile());
    $('#mobile-cover').click(() => closeNavMobile());

    window.addEventListener('resize', () => {
        if ($('.header-mobile-list').hasClass('flex-column') && window.screen.width >= 1023) {
            $('.header-mobile-list').removeClass('flex-column');
            $('.header-mobile-list').addClass('flex-none');
        } else if ($('.header-mobile-list').hasClass('flex-none') && window.screen.width < 1023 ) {
            $('#header-close').css('display', 'none');
            $('#mobile-cover').css('display', 'none');
            $('#header-show').css('display', 'block');
        } 
    });

    // footer mobile click
    $('.footer-list_title').click(event => {
        showOrCloseClick(event.currentTarget, {
            targetContent: 'footer-list_content',
            imgActive: 'arrow-active',
            targetImg: 'footer-list_title img'
        });
    });
})

// 打开移动端导航
function openNavMobile() {
    $('.header-mobile-list').addClass('flex-column');
    $('.header-mobile-list').removeClass('flex-none');
    $('#header-close').show();
    $('#mobile-cover').show();
    $('#header-show').hide();
}

// 关闭移动端导航
function closeNavMobile() {
    $('.header-mobile-list').addClass('flex-none');
    $('.header-mobile-list').removeClass('flex-column');
    $('#header-close').hide();
    $('#mobile-cover').hide();
    $('#J_headerDown_mobile').hide();
    $('#header-show').show();
}

// 移动端 导航 footer列表打开或关闭操作
function showOrCloseClick(event, domObj) {
    const { targetContent, imgActive, targetImg } = domObj;
    // 目标箭头DOM
    const imgDom = $(event).children('img');
    // 目标父元素
    const targetParentDom = event.parentNode;
    // 需要展开的元素
    const showDom = $(targetParentDom).children(`.${targetContent}`);
    
    $(`.${targetContent}`).each((index, item)=> {
        if (item.className.split(' ').indexOf('active') > 0) {
            item.className = `${targetContent} flex-none`;
        } else if (item === showDom[0] && item.className.split(' ').indexOf('active') == -1) {
            item.className = `${targetContent} flex-column active`;
        }
    });

    $(`.${targetImg}`).each((index, item) => {
        if (item.className != '') {
            item.className = '';
        } else if (item === imgDom[0] && item.className == '') {
            item.className = `${imgActive}`;
        }
    });
}

