var commentFun = {
  bind: function () {
    if (window.screen.width < 1023) {
      $('.comment-wrapper_content').css({
        'width': window.screen.width - 120 - 34
      });
    } else {
      $('.comment-wrapper_content').css({
        'width': 'calc(100% - 120px)'
      });
    }

    try {
      swiper = new Swiper('.swiper-container-comment', {
        slidesPerView: window.screen.width < 1023 ? 1 : window.screen.width <= 1150 ? 2 : 3,
        loop: true,
        autoplay: 5000,
      })
      $('.comment-arrow-left').click(function () {
        swiper.swipePrev();
      })
      $('.comment-arrow-right').click(function () {
        swiper.swipeNext();
      })
    } catch (e) {

    }
  }
};
var senceFun = {
  bind: function () {
    try {
      var mySwiper = new Swiper('.swiper-container-sence', {
        slidesPerView: 1, // 垂直切换选项
        loop: true, // 循环模式选项
        autoplay: 5000,
        pagination: '.swiper-pagination',

      })
    } catch (e) {
      console.log('mySwiper错误')
    }
  }
};

const requestData = {
  articleList: function() {
    const articleRouteArray = ["pdfedit", "pdfexchange", "pdfmark", "pdfsoft", "pdfprint", "pdfonline", "pdfocr", "pdfprotect", "pdftranslate"];
    let articleUrlArray = [];
    articleRouteArray.forEach (item => {
      const articleUrl = `https://act.cmcmcdn.com/${item}/index.html.json?v=${new Date().getTime()}`;
      articleUrlArray.push(articleUrl);
    });

    // 所有文章列表
    let articleArray = [];
    // 最新文章列表
    let lasterArticleArray = [];
    // 热门文章列表
    let hostArticleArray = [];

    // 使用 fetch 函数封装 HTTP 请求
    const fetchData = url => fetch(url).then(response => response.json());

    // 使用 Promise.all 发起多个请求
    Promise.all([
      fetchData(articleUrlArray[0]), fetchData(articleUrlArray[1]), fetchData(articleUrlArray[2]),
      fetchData(articleUrlArray[3]), fetchData(articleUrlArray[4]), fetchData(articleUrlArray[5]),
      fetchData(articleUrlArray[6]), fetchData(articleUrlArray[7]), fetchData(articleUrlArray[8])
    ]).then(res => {
      res.forEach(item => {
        articleArray.push(...item.datalist);
      });
      
      // 时间排序
      articleArray.sort((a, b) => new Date(b.publish_date).getTime() - new Date(a.publish_date).getTime());

      // 获取前六篇最新的
      lasterArticleArray = articleArray.slice(0, 6);
      // 随机获取六篇
      for (let index = 0; index < 6; index++) {
        const randomNum = Math.floor(Math.random() * (articleArray.length + 1));
        const randomArticle = articleArray[randomNum];
        const resultArray = lasterArticleArray.find(item => {
          return item.link == randomArticle.link
        })
        if (!resultArray) {
          hostArticleArray.push(randomArticle);
        }
      }

      const lasterArticleDom = document.querySelectorAll("#latest-news ul li a");
      const hostArticleDom = document.querySelectorAll("#hot-news ul li a");

      $(".article-list").removeClass("loading")
      lasterArticleArray.forEach((item, index) => {
        lasterArticleDom[index].href = item.link;
        lasterArticleDom[index].textContent = item.title;
      });
      hostArticleArray.forEach((item, index) => {
        hostArticleDom[index].href = item.link;
        hostArticleDom[index].textContent = item.title;
      });
    })    
  }
}

// 页面初始加载时 移除 article-list 的内容。避免用户感知上出现，加载跟文本一同出现的问题
function removeArticleListContent() {
  Array.from($('.article-list_content ul li a')).forEach(item => {
    item.innerHTML = ''
  })
}

$(function () {
  window.addEventListener('resize', debouce(commentFun.bind, 300));

  function debouce(func, timeDelay) {
    let timeObj;
    return function () {
      clearTimeout(timeObj);
      timeObj = setTimeout(func, timeDelay)
    }
  }

  // 用户评论的轮播图
  commentFun.bind();

  // 使用场景
  senceFun.bind();

  if ($(document).scrollTop() > 1700) {
    if (!loadArticleModule) {
      loadArticleModule = true;
      requestData.articleList();
    }
  }

  $(window).scroll(function () {
    if ($(document).scrollTop() <= 0) {
      $('#J_headerDown').hide();
      $('#J_headerNav').show();
      $('.header').removeClass('page-scroll');
      $('.header').addClass('page-top');
      $('#J_headerDown_mobile').hide();
      $('.header-mobile').removeClass('page-scroll');

      if (window.screen.width <= 1023 && $('#header-show').css('display') == 'none' && $('#mobile-cover').css('display') === 'none') {
        $('#header-show').show();
      }

      if ($('.header-mobile-list').hasClass('flex-column')) {
        $('#header-close').show()
      }
    } else {
      $('#J_headerDown').show();
      $('#J_headerNav').hide();
      $('.header').removeClass('page-top');
      $('.header').addClass('page-scroll');
      $('#J_headerDown_mobile').show();
      $('.header-mobile').addClass('page-scroll');

      if (window.screen.width <= 1023 && $('#header-show').css('display') == 'block') {
        $('#header-show').hide();
      }
      if ($('.header-mobile-list').hasClass('flex-column')) {
        $('#header-close').hide();
      }
    }

    if (!loadArticleModule) {
      loadArticleModule = true;
      requestData.articleList();
    }
  });

  removeArticleListContent()
})