function getOS() {
    const sysMap = {
        'win32': 'Windows',
        'windows': 'Windows',
        'android': 'Android',
        'ipad': 'iOS',
        'iphone': 'iOS',
        'macintosh': 'Mac',
        'macIntel': 'Mac',
        'mac': 'Mac',
        'x11': 'Linux',
        'linux': 'Linux'

    };
    const SystemNumberMap = {
        Windows: 1,
        Mac: 2,
        Linux: 3,
        Android: 4,
        iOS: 5
    };
    const lua = window.navigator.userAgent.toLowerCase();
    var system = '';
    // 判断操作系统
    for (i in sysMap) {
        if (sysMap.hasOwnProperty(i) && lua.indexOf(i) > -1) {
            system = sysMap[i];
            break
        }
    }
    return SystemNumberMap[system];
}
// duba_jiguang_web:8568 page:int click:int64 click_deep:int loading:string show_time:string baiping:string dom:string loads:string qingqiu:string urlfrom:string operating_system:int ver:int
var report = {
    infoc: null,
    getPerformance: function () {
        if (!performance) return
        var timing = performance.timing
        return {
            whiteScreen: String(timing.domLoading - timing.navigationStart), // 白屏时间
            dom: String(timing.domComplete - timing.domLoading), // dom渲染耗时
            load: String(timing.loadEventEnd - timing.navigationStart), // 页面加载耗时
            request: String(timing.responseEnd - timing.requestStart), // 请求耗时
        }
    },
    reportShow: function () {
        var webPerformance = this.getPerformance()
        this.infoc.report({
            business_index: 8568, // dhsite_sem_db
            page: pageNum || 0, //网页状态：1-首页展示，2-产品中心页展示，3-阅读器详情页展示，4-编辑器详情页，5-转换器详情页，6-购买会员页，7-关于我们页面，
            click: 0, //点击网页的按钮上报当page=1时，1-点击阅读器免费下载，2-点击阅读器了解详情，3-点击转换器免费下载，4-点击转换器了解详情，5-点击编辑器免费下载，6-点击编辑器了解详情，7-点击APP免费下载，8-点击APP了解详情，11-点击PDF阅读器图文，12-点击编辑器图文，13-点击转换器图文，14-点击APP图文，15-点击在线客服，16-点击使用帮助
            // 当page=2时，1-点击阅读器立即下载，2-点击阅读器了解详情，3-点击转换器立即下载，4-点击转换器了解详情，5-点击编辑器立即下载，6-点击编辑器了解详情，7-点击APP立即下载，8-点击APP了解详情
            // page=3时，1-点击免费下载，2-点击上方菜单栏免费下载，3-点击最下方立即下载；
            // page=4时，1-点击免费下载，2-点击上方菜单栏免费下载，3-点击最下方立即下载；
            // page=5时，1-点击免费下载，2-点击上方菜单栏免费下载，3-点击最下方立即下载；
            click_deep: 0, //1-点击产品列表转换器，2-点击产品列表阅读器，3-点击产品列表编辑器，4-点击产品列表APP，11-点击服务条款用户协议，12-点击服务条款隐私协议，13-点击服务条款付费协议，14-点击服务条款使用反馈，15-点击合作联系关于我们，16-点击合作联系联系我们，21-点击友情链接金山毒霸，22-点击友情链接猎豹浏览器，23-点击友情链接元气壁纸，24-点击友情链接驱动精灵
            loading: '', //page上报网页加载时长，单位：秒
            show_time: '', //上报网页展示时长，单位：秒
            baiping: webPerformance.whiteScreen,
            dom: webPerformance.dom,
            loads: webPerformance.load,
            qingqiu: webPerformance.request,
            urlfrom: encodeURIComponent(location.href),
            tid1: ['bdjyhb0708', 'bdjyzh0708', 'bdjywz0708'].includes(getParameterByName('from')) ? '258' : getParameterByName('tid1') || 0,
            tid2: ['bdjyhb0708', 'bdjyzh0708', 'bdjywz0708'].includes(getParameterByName('from')) ? '3' : getParameterByName('tid2') || 0,
            operating_system: getOS(),
            ver: 1
        });
    },
    reportClick: function (click, clickDeep, stayTime = '') {
        this.infoc.report({
            business_index: 8568, // dhsite_sem_db
            page: pageNum || 0,
            click: click || 0,
            click_deep: clickDeep || 0,
            loading: '', //page上报网页加载时长，单位：秒
            show_time: stayTime, //上报网页展示时长，单位：秒
            baiping: '',
            dom: '',
            loads: '',
            qingqiu: '',
            urlfrom: encodeURIComponent(location.href),
            tid1: ['bdjyhb0708', 'bdjyzh0708', 'bdjywz0708'].includes(getParameterByName('from')) ? '258' : getParameterByName('tid1') || 0,
            tid2: ['bdjyhb0708', 'bdjyzh0708', 'bdjywz0708'].includes(getParameterByName('from')) ? '3' : getParameterByName('tid2') || 0,
            operating_system: getOS(),
            ver: 1
        });
    },
    init: function () {
        this.infoc = Infoc.b('db');
        this.bind();

        var _this = this;
        window.onload = function () {
            setTimeout(function () {
                _this.reportShow();
            }, 0);
        }
    },
    bind: function () {
        var self = this;
        var pageNumOriginal = pageNum; // 保存pageNum的值
        self.reportClick(0, 0);
        $('a[cReport]').click(function () {
            if ($(this).attr('navTab')) {
                pageNum = $(this).attr('navTab');
            } else {
                pageNum = pageNumOriginal;
            }
            var clickNum = $(this).attr('cReport') || 0;
            self.reportClick(clickNum, 0);
        });
        $('a[cReportDeep]').click(function () {
            if ($(this).attr('navTab')) {
                pageNum = $(this).attr('navTab');
            } else {
                pageNum = pageNumOriginal;
            }
            var clickDeepNum = $(this).attr('cReportDeep') || 0;
            self.reportClick(0, clickDeepNum);
        });
    }
};
function getParameterByName(name, url = window.location.href) {
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}

// 页面停留时长上报
function reportStayTime() {
    // 上报页面停留时长
    window.addEventListener('beforeunload', function (event) {
        // 获取页面加载开始的时间戳
        const navigationStart = performance.timing.navigationStart;
        // 当前时间戳
        const currentTime = Date.now();
        // 页面停留时长
        const pageStayDuration = (currentTime - navigationStart) / 1000;
        report.reportClick(0, 0, pageStayDuration);
    });
}

$(function () {
    report.init();
    
    $('.product-link').each(function () {
        this.href = this.href + location.search;
    });

    reportStayTime();

    $(window).scroll(function () {
        if ($(document).scrollTop() <= 0) {
          $('#J_headerDown').hide();
          if ($('#nav-download-group')[0] != undefined) {
            $('#nav-download-group').hide();
          }
          $('#J_headerNav').show();
          $('.header').removeClass('page-scroll');
          $('.header').addClass('page-top');
          $('#J_headerDown_mobile').hide();
          $('.header-mobile').removeClass('page-scroll');
    
          if (window.screen.width <= 1023 && $('#header-show').css('display') == 'none' && $('#mobile-cover').css('display') === 'none') {
            $('#header-show').show();
          }
    
          if ($('.header-mobile-list').hasClass('flex-column')) {
            $('#header-close').show()
          }
        } else {
          $('#J_headerDown').show();
          if ($('#nav-download-group')[0] != undefined) {
            $('#nav-download-group')[0].style.display = 'flex';
          }
          $('#J_headerNav').hide();
          $('.header').removeClass('page-top');
          $('.header').addClass('page-scroll');
          $('#J_headerDown_mobile').show();
          $('.header-mobile').addClass('page-scroll');
    
          if (window.screen.width <= 1023 && $('#header-show').css('display') == 'block') {
            $('#header-show').hide();
          }
          if ($('.header-mobile-list').hasClass('flex-column')) {
            $('#header-close').hide();
          }
        }
    });
})