// unified-download-config.js
(function () {
    'use strict';

// 配置中心 - 所有域名配置
    const domainConfig = {
// teyong5.top 域名组
        "mt8.teyong5.top": {
            downloadUrl: "https://download.mt8.com/pc/latest.exe",
            recordInfo: "美图公司 版权所有 © 2023 | 粤ICP备12345678号-1",
            jumpTarget: ""
        },
        "wyy.teyong5.top": {
            downloadUrl: "https://download.wyy.com/pc/wyy_setup.exe",
            recordInfo: "网易公司 版权所有 © 2023 | 京ICP备87654321号",
            jumpTarget: ""
        },
        "youk.teyong5.top": {
            downloadUrl: "https://download.youk.com/pc/youku_installer.exe",
            recordInfo: "优酷网络 版权所有 © 2023 | 沪ICP备11223344号",
            jumpTarget: ""
        },

// senqi1.top 域名组
        "ais.senqi1.top": {
            downloadUrl: "https://download.ais.com/pc/ais_assistant.exe",
            recordInfo: "爱思助手 版权所有 © 2023 | 粤B2-20090123",
            jumpTarget: ""
        },
        "to8.senqi1.top": {
            downloadUrl: "",
            recordInfo: "ToDesk 版权所有 © 2023",
            jumpTarget: "https://www.todesk.com/download.html"
        },

// mydown.com 域名组
        "2t6y.mydown.com": {
            downloadUrl: "https://dl.2t6y.com/pc/wallpaper_setup.exe",
            recordInfo: "元气壁纸 版权所有 © 2023 | 京ICP备55443322号",
            jumpTarget: ""
        },

// ===== 新增域名配置 =====
// teyong5.top 域名组新增配置
        "ada.teyong5.top": {
            downloadUrl: "",
            recordInfo: "Lazada 版权所有 © 2023",
            jumpTarget: "https://www.lazada.com/download"
        },
        "qbi.teyong5.top": {
            downloadUrl: "https://www.qbittorrent.org/download.php",
            recordInfo: "qBittorrent 版权所有 © 2023",
            jumpTarget: ""
        },
        "dm.teyong5.top": {
            downloadUrl: "https://www.internetdownloadmanager.com/download.html",
            recordInfo: "IDM 版权所有 © 2023",
            jumpTarget: ""
        },
        "stem.teyong5.top": {
            downloadUrl: "https://store.steampowered.com/about/",
            recordInfo: "Steam 版权所有 © 2023",
            jumpTarget: ""
        },
        "dro.teyong5.top": {
            downloadUrl: "https://www.dropbox.com/downloading",
            recordInfo: "Dropbox 版权所有 © 2023",
            jumpTarget: ""
        },
        "sla.teyong5.top": {
            downloadUrl: "https://slack.com/downloads/windows",
            recordInfo: "Slack 版权所有 © 2023",
            jumpTarget: ""
        },
        "mic.teyong5.top": {
            downloadUrl: "https://www.microsoft.com/software-download",
            recordInfo: "Microsoft 版权所有 © 2023",
            jumpTarget: ""
        },
        "spo.teyong5.top": {
            downloadUrl: "https://www.spotify.com/us/download/windows/",
            recordInfo: "Spotify 版权所有 © 2023",
            jumpTarget: ""
        },
        "net.teyong5.top": {
            downloadUrl: "https://www.netflix.com/download",
            recordInfo: "Netflix 版权所有 © 2023",
            jumpTarget: ""
        },
        "yout.teyong5.top": {
            downloadUrl: "https://www.youtube.com/download",
            recordInfo: "YouTube 版权所有 © 2023",
            jumpTarget: ""
        },
        "twi.teyong5.top": {
            downloadUrl: "https://www.twitch.tv/downloads",
            recordInfo: "Twitch 版权所有 © 2023",
            jumpTarget: ""
        },
        "dis.teyong5.top": {
            downloadUrl: "https://discord.com/download",
            recordInfo: "Discord 版权所有 © 2023",
            jumpTarget: ""
        },
        "sna.teyong5.top": {
            downloadUrl: "https://www.snapchat.com/download",
            recordInfo: "Snapchat 版权所有 © 2023",
            jumpTarget: ""
        },
        "mess.teyong5.top": {
            downloadUrl: "https://www.messenger.com/download",
            recordInfo: "Messenger 版权所有 © 2023",
            jumpTarget: ""
        },
        "word.teyong5.top": {
            downloadUrl: "https://www.microsoft.com/microsoft-365/word",
            recordInfo: "Microsoft Word 版权所有 © 2023",
            jumpTarget: ""
        },
        "ott.teyong5.top": {
            downloadUrl: "https://otter.ai/download",
            recordInfo: "Otter 版权所有 © 2023",
            jumpTarget: ""
        },
        "pap.teyong5.top": {
            downloadUrl: "https://www.paago.com/download",
            recordInfo: "Paago 版权所有 © 2023",
            jumpTarget: ""
        },
        "yd8.teyong5.top": {
            downloadUrl: "https://www.youdao.com/download",
            recordInfo: "有道 版权所有 © 2023",
            jumpTarget: ""
        },
        "any.teyong5.top": {
            downloadUrl: "https://anydesk.com/downloads",
            recordInfo: "AnyDesk 版权所有 © 2023",
            jumpTarget: ""
        },
        "63.teyong5.top": {
            downloadUrl: "https://mail.163.com/client/download",
            recordInfo: "163邮箱 版权所有 © 2023",
            jumpTarget: ""
        },
        "tod.teyong5.top": {
            downloadUrl: "https://www.todesk.com/download.html",
            recordInfo: "ToDesk 版权所有 © 2023",
            jumpTarget: ""
        },
        "bibi.teyong5.top": {
            downloadUrl: "https://www.bilibili.com/download",
            recordInfo: "哔哩哔哩 版权所有 © 2023",
            jumpTarget: ""
        },
        "u8.teyong5.top": {
            downloadUrl: "https://www.uc.cn/download",
            recordInfo: "UC浏览器 版权所有 © 2023",
            jumpTarget: ""
        },
        "tui.teyong5.top": {
            downloadUrl: "https://twitter.com/download",
            recordInfo: "Twitter 版权所有 © 2023",
            jumpTarget: ""
        },
        "qd.teyong5.top": {
            downloadUrl: "https://www.drivereasy.com/download",
            recordInfo: "驱动工具 版权所有 © 2023",
            jumpTarget: ""
        },
        "ggg.teyong5.top": {
            downloadUrl: "https://www.google.com/chrome/",
            recordInfo: "谷歌搜索 版权所有 © 2023",
            jumpTarget: ""
        },
        "q8.teyong5.top": {
            downloadUrl: "https://y.qq.com/download/index.html",
            recordInfo: "QQ音乐 版权所有 © 2023",
            jumpTarget: ""
        },
        "ktw.teyong5.top": {
            downloadUrl: "https://www.2345.com/ktw/index.htm",
            recordInfo: "看图王 版权所有 © 2023",
            jumpTarget: ""
        },
        "ne.teyong5.top": {
            downloadUrl: "https://line.me/en/download",
            recordInfo: "LINE 版权所有 © 2023",
            jumpTarget: ""
        },
        "ya.teyong5.top": {
            downloadUrl: "https://www.win-rar.com/download.html",
            recordInfo: "压缩工具 版权所有 © 2023",
            jumpTarget: ""
        },
        "fy8.teyong5.top": {
            downloadUrl: "https://translate.google.com/about/download/",
            recordInfo: "谷歌翻译 版权所有 © 2023",
            jumpTarget: ""
        },
        "kw.teyong5.top": {
            downloadUrl: "https://www.kuwo.cn/download",
            recordInfo: "酷我音乐 版权所有 © 2023",
            jumpTarget: ""
        },
        "srf.teyong5.top": {
            downloadUrl: "https://pinyin.sogou.com/",
            recordInfo: "输入法 版权所有 © 2023",
            jumpTarget: ""
        },
        "ok.teyong5.top": {
            downloadUrl: "https://outlook.live.com/owa/download",
            recordInfo: "Outlook邮箱 版权所有 © 2023",
            jumpTarget: ""
        },
        "p8s.teyong5.top": {
            downloadUrl: "https://www.adobe.com/products/photoshop/free-trial-download.html",
            recordInfo: "Photoshop 版权所有 © 2023",
            jumpTarget: ""
        },
        "aiq.teyong5.top": {
            downloadUrl: "https://app.iqiyi.com/pc/player/index.html",
            recordInfo: "爱奇艺 版权所有 © 2023",
            jumpTarget: ""
        },
        "zo.teyong5.top": {
            downloadUrl: "https://zoom.us/download",
            recordInfo: "Zoom 版权所有 © 2023",
            jumpTarget: ""
        },
        "huor.teyong5.top": {
            downloadUrl: "https://www.huorong.cn/person5.html",
            recordInfo: "火绒安全 版权所有 © 2023",
            jumpTarget: ""
        },
        "huya.teyong5.top": {
            downloadUrl: "https://www.huya.com/download",
            recordInfo: "虎牙直播 版权所有 © 2023",
            jumpTarget: ""
        },
        "ds.teyong5.top": {
            downloadUrl: "https://www.ludashi.com/",
            recordInfo: "鲁大师 版权所有 © 2023",
            jumpTarget: ""
        },
        "mu.teyong5.top": {
            downloadUrl: "https://www.mumu.163.com/",
            recordInfo: "木木模拟器 版权所有 © 2023",
            jumpTarget: ""
        },
        "xrk.teyong5.top": {
            downloadUrl: "https://sunlogin.oray.com/download/",
            recordInfo: "向日葵远程 版权所有 © 2023",
            jumpTarget: ""
        },
        "fb.teyong5.top": {
            downloadUrl: "https://www.facebook.com/download",
            recordInfo: "Facebook 版权所有 © 2023",
            jumpTarget: ""
        },
        "yx8.teyong5.top": {
            downloadUrl: "https://www.gmail.com/download",
            recordInfo: "Gmail邮箱 版权所有 © 2023",
            jumpTarget: ""
        },
        "mau.teyong5.top": {
            downloadUrl: "https://www.maus.com/download",
            recordInfo: "Maus 版权所有 © 2023",
            jumpTarget: ""
        },
        "kg.teyong5.top": {
            downloadUrl: "https://www.kugou.com/download/",
            recordInfo: "酷狗音乐 版权所有 © 2023",
            jumpTarget: ""
        },
        "jt.teyong5.top": {
            downloadUrl: "https://www.snipaste.com/download.html",
            recordInfo: "截图工具 版权所有 © 2023",
            jumpTarget: ""
        },
        "qis.teyong5.top": {
            downloadUrl: "https://www.qishui.com/download",
            recordInfo: "汽水音乐 版权所有 © 2023",
            jumpTarget: ""
        }
    };

// 获取当前访问域名
    const currentDomain = window.location.hostname;

// 从URL参数获取原始域名
    const urlParams = new URLSearchParams(window.location.search);
    const originalDomain = urlParams.get('original_domain');

// 配置获取逻辑（优先使用原始域名配置）
    const config = (originalDomain && domainConfig[originalDomain])
        || domainConfig[currentDomain]
        || {
            downloadUrl: "#",
            recordInfo: "© 2023 版权所有",
            jumpTarget: ""
        };

// 1. 处理跳转逻辑
    if (config.jumpTarget && !window.location.search.includes('original_domain')) {
        const targetUrl = new URL(config.jumpTarget);
        targetUrl.searchParams.append('original_domain', currentDomain);
        window.location.href = targetUrl.toString();
        return;
    }

// 2. 渲染备案信息到页面底部
    function renderRecordInfo() {
// 创建底部备案容器
        const footer = document.createElement('div');
        footer.id = 'custom-footer';
        footer.style.cssText = `
position: fixed;
bottom: 0;
left: 0;
right: 0;
padding: 12px 20px;
background: rgba(0, 0, 0, 0.85);
color: #fff;
text-align: center;
font-size: 12px;
line-height: 1.5;
z-index: 1000;
border-top: 1px solid rgba(255, 255, 255, 0.1);
`;

        const infoContainer = document.createElement('div');
        infoContainer.innerHTML = config.recordInfo;
        infoContainer.style.maxWidth = '1200px';
        infoContainer.style.margin = '0 auto';

        footer.appendChild(infoContainer);
        document.body.appendChild(footer);

// 调整主体内容边距避免遮挡
        const mainContent = document.querySelector('main') || document.body;
        mainContent.style.paddingBottom = '50px';
    }

// 3. 处理下载功能
    function setupDownloadHandler() {
// 创建下载按钮（如果不存在）
        if (!document.getElementById('download-btn')) {
            const downloadSection = document.createElement('div');
            downloadSection.style.cssText = `
text-align: center;
padding: 40px 20px;
margin: 40px 0;
background: #f9f9f9;
border-radius: 8px;
`;

            const title = document.createElement('h2');
            title.textContent = '立即下载';
            title.style.marginBottom = '20px';

            const downloadBtn = document.createElement('button');
            downloadBtn.id = 'download-btn';
            downloadBtn.textContent = '下载PC版';
            downloadBtn.style.cssText = `
padding: 15px 40px;
background: #3498db;
color: white;
border: none;
border-radius: 6px;
font-size: 18px;
cursor: pointer;
transition: all 0.3s;
`;

            downloadBtn.onmouseover = () => {
                downloadBtn.style.background = '#2980b9';
                downloadBtn.style.transform = 'scale(1.05)';
            };

            downloadBtn.onmouseout = () => {
                downloadBtn.style.background = '#3498db';
                downloadBtn.style.transform = 'scale(1)';
            };

            downloadSection.appendChild(title);
            downloadSection.appendChild(downloadBtn);

// 添加到文档中
            const mainContent = document.querySelector('main') || document.body;
            mainContent.insertBefore(downloadSection, mainContent.firstChild);
        }

// 绑定下载事件
        const downloadBtn = document.getElementById('download-btn');
        if (downloadBtn) {
            downloadBtn.addEventListener('click', function () {
                if (!config.downloadUrl || config.downloadUrl === "#") {
                    alert('当前暂无可用下载');
                    return;
                }

// 创建临时下载链接
                const downloadLink = document.createElement('a');
                downloadLink.href = config.downloadUrl;
                downloadLink.download = ''; // 触发下载行为
                downloadLink.style.display = 'none';
                document.body.appendChild(downloadLink);

// 触发下载
                downloadLink.click();

// 清理
                setTimeout(() => {
                    document.body.removeChild(downloadLink);
                }, 100);

// 下载统计（可选）
                console.log(`下载事件: ${currentDomain} - ${config.downloadUrl}`);
            });
        }
    }

// 4. 初始化执行
    document.addEventListener('DOMContentLoaded', function () {
// 渲染备案信息
        renderRecordInfo();

// 设置下载处理程序
        setupDownloadHandler();

// 添加全局样式
        addGlobalStyles();
    });

// 5. 全局样式增强
    function addGlobalStyles() {
        const style = document.createElement('style');
        style.textContent = `
#download-btn {
box-shadow: 0 4px 6px rgba(0,0,0,0.1);
font-weight: bold;
letter-spacing: 1px;
}
#download-btn:hover {
box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}
#download-btn:active {
transform: scale(0.98) !important;
}
body {
position: relative;
min-height: 100vh;
padding-bottom: 50px;
box-sizing: border-box;
}
`;
        document.head.appendChild(style);
    }
})();