// 定义域名配置
const currentDomain = window.location.hostname;
// const currentDomain = 'aqllq.qinruiw.cn';

// 定义域名配置
const domainConfigs = {
    'aqllq.softap.cn': {
        logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
        company: '马鞍山晓宁网络科技有限公司合肥分公司',
        icp: '皖ICP备2021017457号-1',
        company_address: '安徽省合肥市经济技术开发区海恒社区建业时光原著7栋1102室',
        company_phone: '联系电话：4006886510',
        jump_link: 'https://aqllq.softap.cn'
    },
    'aqllq.fengal.cn': {
        logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
        company: '马鞍山顺瑶网络科技有限公司合肥分公司',
        icp: '皖ICP备2022000564号-4',
        company_address: '安徽省合肥市蜀山区五里墩街道史河路与潜山路交口凤凰城燕园15栋602室',
        company_phone: '联系电话：4006886510',
        jump_link: 'https://aqllq.fengal.cn'
    },
    'aqllq.fengmie.cn': {
        logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
        company: '马鞍山晓宁网络科技有限公司',
        icp: '皖ICP备2021017457号',
        company_address: '马鞍山市花山区霍里镇霍里山大道北段698号',
        company_phone: '联系电话：4006886510',
        jump_link: 'https://aqllq.fengmie.cn'
    },
    'aqllq.zuitie.cn': {
        logo: 'https://soft.uesou.cn/images/logo/baozang-v3.png',
        company: '马鞍山超聪网络科技有限公司',
        icp: '皖ICP备2021013870号-9',
        company_address: '马鞍山市郑蒲港新区孵化园6号楼4层',
        company_phone: '联系电话：4006886515',
        jump_link: 'https://aqllq.zuitie.cn'
    },
    'aqllq.sengfeng.cn': {
        logo: 'http://soft.uesou.cn/images/shuihua.png',
        company: '合肥水花网络科技有限公司',
        icp: '皖ICP备2022004577号-3',
        company_address: '中国(安徽)自由贸易试验区合肥市高新区习友路3333号中国(合肥)国际智能语音产业园研发中心楼508-1室 ',
        company_phone: '联系电话：4006886515',
        jump_link: 'https://aqllq.sengfeng.cn'
    },
    'aqllq.qinruiw.cn': {
      logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
      company: '莆田市勤瑞网络科技有限公司 ',
      icp: '闽ICP备2023026585号',
      company_address: '福建省莆田市城厢区霞林街道棠霞路1548号、1552号、1556号、1560号、1564号、1568号、1572号(集群注册) ',
      company_phone: '联系电话400-6493699',
      jump_link: 'https://aqllq.qinruiw.cn'
    },
    'aqllq.xuanbenw.cn': {
      logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
      company: '莆田市旋本网络科技有限公司',
      icp: '闽ICP备2023023378号',
      company_address: '闽ICP备2023023378号 福建省莆田市城厢区霞林街道棠霞路1548号、1552号、1556号、1560号、1564号、1568号、1572号(集群注册) ',
      company_phone: '联系电话400-6493699',
      jump_link: 'https://aqllq.xuanbenw.cn'
    },
    'aqllq.sidiwk.cn': {
      logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
      company: '莆田市丝迪网络科技有限公司',
      icp: '闽ICP备2023025607号',
      company_address: '福建省莆田市城厢区霞林街道棠霞路1548号、1552号、1556号、1560号、1564号、1568号、1572号(集群注册) ',
      company_phone: '联系电话400-6493699',
      jump_link: 'https://aqllq.sidiwk.cn'
    },
    'aqllq.sengzai.com': {
      logo: 'https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png',
      company: '马鞍山圣秦网络科技有限公司合肥分公司',
      icp: '皖ICP备2021013847号-5 ',
      company_address: '安徽省合肥市瑶海区龙岗综合经济开发区龙岗路公园天著10栋502室 ',
      company_phone: '联系电话：4006886510',
      jump_link: 'https://aqllq.sengzai.com'
    }
};

// 获取当前域名配置
const currentConfig = domainConfigs[currentDomain] || domainConfigs['aqllq.softap.cn'];


// 更新底部信息
function updateFooterInfo() {
    // 更新ICP备案号
    const icpElement = document.querySelector('.fst_btm_t');
    if (icpElement) {
        icpElement.textContent = currentConfig.icp;
    }

    // 更新公司信息
    const companyInfoElement = document.querySelector('.fst_btm_t');
    if (companyInfoElement) {
        companyInfoElement.innerHTML = `
            <span>${currentConfig.company}</span>
            <span>${currentConfig.company_address}</span>
            <span>${currentConfig.company_phone}</span>
            <span>${currentConfig.icp}</span>
        `;
    }

    // 更新logo
    const pageLogo = document.querySelector('.page_logo');
    if (pageLogo) {
        // 判断是否需要只显示左边logo
        const specialDomains = ['aqllq.softap.cn', 'aqllq.fengal.cn', 'aqllq.fengmie.cn','aqllq.qinruiw.cn', 'aqllq.sidiwk.cn', 'aqllq.sengzai.com','aqllq.xuanbenw.cn'];
        const isSpecialDomain = specialDomains.includes(currentDomain);

        if (isSpecialDomain) {
            // 只显示左边logo，并添加跳转功能
            pageLogo.innerHTML = `
                <div class="logo1">
                    <a href="${currentConfig.jump_link}" class="a1" target="_blank" >
                        <img src="${currentConfig.logo}" alt="/" class="img1">
                    </a>
                </div>
            `;
        } else {
            // 显示两个logo，右边logo有跳转功能
            pageLogo.innerHTML = `
                <div class="logo1">
                    <a href="" class="a1">
                        <img src="https://p5.ssl.qhimg.com/t017dfc52d1815674e8.png" alt="/" class="img1">
                    </a>
                </div>
                <div class="logo2">
                    <a href="${currentConfig.jump_link}" target="_blank">
                        <img src="${currentConfig.logo}" alt="/">
                    </a>
                </div>
            `;
        }
    }
}

// 页面加载完成后执行
document.addEventListener('DOMContentLoaded', updateFooterInfo);


