"use strict";

var PC_SETUP_URL = "";
var ANDROID_SETUP_URL = "https://img.kaiheila.cn/assets/kaiheila_release_1.0.0.apk";
function getPlantformDownloadLink(platform, cb) {
  if (platform === 'booster') {
    // 加速器通过setting接口获取
    window._request.get("/api/v3/user/settings").then(function (res) {
      var _res$data;
      if (res.code == 0 && (_res$data = res.data) !== null && _res$data !== void 0 && (_res$data = _res$data.kook_booster_settings) !== null && _res$data !== void 0 && _res$data.download_url) {
        cb(res.data.kook_booster_settings.download_url);
      }
    });
    return;
  }
  window._request.get("/api/v2/updates/latest-version", {
    platform: platform
  }).then(function () {
    var res = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (res.url) {
      cb(res.url);
    }
  });
}
function downloadPackage(plactform) {
  getPlantformDownloadLink(plactform, function (url) {
    var a = document.createElement('a');
    a.href = url;
    a.target = '_blank';
    a.click();
    a = null;
  });
}
window._downloadPackage = downloadPackage;
document.addEventListener('click', function (event) {
  var elm = event.target;
  if (elm instanceof HTMLElement) {
    var isPCDownload = elm.classList.contains('pc-download-btn');
    if (isPCDownload) {
      downloadPackage('windows');
    }
    var isAndrioDownload = elm.classList.contains('andrio-download-btn');
    if (isAndrioDownload) {
      downloadPackage('android');
    }
    var isBoosterDownload = elm.classList.contains('booster-download-btn');
    if (isBoosterDownload && !elm.getAttribute('href')) {
      downloadPackage('booster');
    }
  }
}, true);
getPlantformDownloadLink("windows", function (url) {
  PC_SETUP_URL = url;
  $("#type-download-btn").removeClass("disabled");
  $(".pc-download-btn").attr("href", url);
});
getPlantformDownloadLink("android", function (url) {
  ANDROID_SETUP_URL = url;
});
$(function () {
  var handleClickHeaderDownload = {
    openModal: function openModal(isBaiduYingxiao) {
      var $downloadAppsDom = $("<div class='kaihei-mask-container'>\n              <div class=\"modal-body\">\n                <div class=\"close-btn\"></div>\n                <div class=\"modal-title\">\u4E0B\u8F7D\u5BA2\u6237\u7AEF</div>\n                <div class=\"modal-content\">\n        \n                <div class=\"tab-title-list\">\n                  <div data-key=\"default\" class=\"tab-title active\">KOOK\u8BED\u97F3</div>\n                  <div data-key=\"booster\" class=\"tab-title\">KOOK\u52A0\u901F\u5668</div>\n                </div>\n\n                <div class=\"tab-content\" style=\"width:849px;\">\n\n                 <div class='download-card-list' data-targetkey=\"default\" data-width=\"849\">\n                  <div class=\"download-card-item card-layout\">\n                    <div class=\"download-logo\">\n                      <img class='download-icon' src=\"/css/image/win-icon.svg\" alt=\"\"/>\n                    </div>\n                    <div class=\"text\">Windows\u5BA2\u6237\u7AEF</div>\n                    <a class=\"download-btn pc-download-btn status-button\">\u7ACB\u5373\u4E0B\u8F7D\n                    </a>\n                  </div>\n        \n                  <div class=\"download-card-item double\">\n                    <div class=\"card-layout front\">\n                      <div class=\"download-logo\"><img class='download-icon' src=\"/css/image/ios-icon.svg\" alt=\"\"/></div>\n                      <div class=\"text\">iOS\u5BA2\u6237\u7AEF</div>\n                      <a class=\"download-btn status-button\">\u7ACB\u5373\u4E0B\u8F7D</a>\n                    </div>\n                    <div class=\"card-layout back\">\n                      <div class=\"download-logo\">\n                        <img class='qrcode' src=\"/css/image/ios-qrcode.png\" alt=\"\"/>\n                      </div>\n                      <div class=\"text\">\u626B\u7801\u4E0B\u8F7DiOS\u5BA2\u6237\u7AEF</div>\n                      <a class=\"download-btn status-button\" target=\"_blank\" href=\"https://apps.apple.com/cn/app/%E5%BC%80%E9%BB%91%E5%95%A6-%E4%B8%BA%E6%B8%B8%E6%88%8F%E8%80%8C%E7%94%9F/id1501289327\">App Store\u4E0B\u8F7D</a>\n                    </div>\n                  </div>\n        \n                  <div class=\"download-card-item double\">\n                    <div class=\"front card-layout\">\n                      <div class=\"download-logo\"><img class='download-icon' src=\"/css/image/android-icon.svg\" alt=\"\"/></div>\n                      <div class=\"text\">Android\u5BA2\u6237\u7AEF</div>\n                      <a class=\"download-btn andrio-download-btn status-button\">\u7ACB\u5373\u4E0B\u8F7D</a>\n                    </div>\n        \n                    <div class=\"back card-layout\">\n                      <div class=\"download-logo\"><img class='qrcode' src=\"/css/image/android_qrcode.png\" alt=\"\"/></div>\n                      <div class=\"text\">\u626B\u7801\u4E0B\u8F7DAndroid\u5BA2\u6237\u7AEF</div>\n                      <a class=\"download-btn andrio-download-btn status-button\">\u7ACB\u5373\u4E0B\u8F7D\n                      </a>\n                    </div>\n                  </div>\n              </div>\n        \n              <div data-targetkey=\"booster\" style=\"display:none\" class='download-card-list' data-width=\"520\">\n                  <div class=\"download-card-item card-layout\">\n                    <div class=\"download-logo\">\n                      <img class='download-icon' src=\"/css/image/booster-logo@2x.svg\" alt=\"\"/>\n                    </div>\n                    <div class=\"text\">KOOK\u52A0\u901F\u5668</div>\n                    <a ".concat(window.KOOK_BOOSTER_DOWNLOAD_URL ? "href=\"".concat(window.KOOK_BOOSTER_DOWNLOAD_URL, "\"") : '', " class=\"download-btn booster-download-btn status-button\">\u7ACB\u5373\u4E0B\u8F7D\n                    </a>\n                  </div>\n              </div>\n        \n\n                </div>\n        \n               \n        \n            </div>\n              </div>\n            </div>"));
      $("body").append($downloadAppsDom);
      var _keyEvent = function keyEvent(event) {
        var keyCode = event.keyCode;
        if (keyCode === 27) {
          $downloadAppsDom.remove();
          $(document).off("keydown", _keyEvent);
        }
      };
      $(document).on("keydown", _keyEvent);
      $downloadAppsDom.find(".modal-body").click(function (e) {
        e.stopPropagation();
      });
      $downloadAppsDom.find(".close-btn").click(function (e) {
        $downloadAppsDom.remove();
      });
      $(".kaihei-mask-container").click(function () {
        $(this).remove();
      });
      $downloadAppsDom.find(".tab-title").click(function (e) {
        var key = $(e.target).data('key');
        $(e.target).addClass('active').siblings(".tab-title").removeClass('active');
        var $content = $downloadAppsDom.find(".download-card-list[data-targetkey=\"".concat(key, "\"]"));
        var width = $content.data('width');
        $content.removeAttr('style').siblings(".download-card-list").css('display', 'none');
        width && $downloadAppsDom.find('.tab-content').css('width', "".concat(width, "px"));
      });
    },
    openAndroidDownload: function openAndroidDownload() {
      window.location.href = "https://android.myapp.com/myapp/detail.htm?apkName=cn.kaiheila";
    },
    openIosDownload: function openIosDownload() {
      window.location.href = "https://apps.apple.com/us/app/id1501289327?l=zh&ls=1";
    }
  };
  $(".download-all-btn").click(function () {
    if (/Android/.test(navigator.userAgent)) {
      handleClickHeaderDownload.openAndroidDownload();
    } else if (/(iPhone|iPad)/.test(navigator.userAgent)) {
      handleClickHeaderDownload.openIosDownload();
    } else {
      // if (/windows/gi.test(navigator.userAgent)) {}
      // 百度营销
      handleClickHeaderDownload.openModal(window.isBaiduYingxiao);
    }
  });
  // 百度营销
  if (window.isBaiduYingxiao) {
    $("#type-download-btn").attr("data-agl-cvt", "6");
    $("#btn-quick-start").attr("data-agl-cvt", "6");
  }
  var $header = $(".custom-header");
  if ($header.length > 0 && $(".main")) {
    var height = $header.height();
    if (height) {
      $(".main").css({
        paddingTop: height + "px"
      });
    }
  }
});