"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: !1, writable: !0, configurable: !0 } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function stringify(obj) {
  var str = '';
  for (var key in obj) {
    str += "".concat(key, "=").concat(obj[key], "&");
  }
  return str.length > 0 ? str.substr(0, str.length - 1) : str;
}
function getQueryPath() {
  var path = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var query = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var search = stringify(query);
  if (search.length) {
    return "".concat(path, "?").concat(search);
  }
  return path;
}
var ApiError = /*#__PURE__*/function (_Error) {
  function ApiError(_ref) {
    var _this;
    var _ref$code = _ref.code,
      code = _ref$code === void 0 ? 400 : _ref$code,
      _ref$message = _ref.message,
      message = _ref$message === void 0 ? '出现错误' : _ref$message,
      _ref$error = _ref.error,
      error = _ref$error === void 0 ? '接口400,无error信息' : _ref$error;
    _classCallCheck(this, ApiError);
    _this = _callSuper(this, ApiError);
    _this.errorResponse = {
      code: code,
      message: message,
      error: error
    };
    return _this;
  }
  _inherits(ApiError, _Error);
  return _createClass(ApiError);
}(/*#__PURE__*/_wrapNativeSuper(Error));
var checkStatus = function checkStatus(options) {
  return function (response) {
    if (response.status >= 200 && response.status < 300) {
      return response;
    } else if (response.status === 400) {
      //400错误码特殊处理
      return response.text().then(function (text) {
        var err = new ApiError({});
        try {
          err = new ApiError(JSON.parse(text));
        } finally {
          // typeof err.errorResponse.message === 'string' && options.showMsg && Message.error(err.errorResponse.message || '处理失败', 3000)
          throw err.errorResponse;
        }
      });
    } else if (response.status === 401) {
      //401错误码统一处理
      return Promise.reject('未登录');
    } else if (response.status === 403) {
      //403，越权访问单独处理
      // window.location.href='/app/discover'
      var err = new ApiError({
        code: 403,
        message: '服务器出现错误',
        error: '越权访问'
      });
      throw err.errorResponse;
    } else {
      // options.showMsg && Message.error('网络错误', 2000)
      return Promise.reject('网络错误');
    }
  };
};

/**
 *  fetch 请求封装
 * @param {*} url
 * @param {*} method
 * @param {*} data
 * @param {*} timeout
 */
var request = function request(url) {
  var method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'POST';
  var data = arguments.length > 2 ? arguments[2] : undefined;
  var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var timeout = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 5000;
  var opts = {
    method: method,
    timeout: timeout,
    credentials: 'include',
    headers: {
      'Content-Type': 'application/json; charset=utf-8'
    },
    url: url
  };
  if (method !== 'GET') {
    opts.body = JSON.stringify(data);
  } else {
    var newUrl = getQueryPath(url, data);
    if (data) {
      opts.url = newUrl;
    }
  }
  return $.ajax(opts);
  // return fetch(url, opts)
  //   .then(checkStatus(options))
  //   .then(response => {
  //     if (response.status === 204) {
  //       return Promise.resolve()
  //     } else {
  //       return response.json()
  //     }

  //   })
  //   .catch((e) => {
  //     throw e
  //   })
};
window._request = {
  get: function get(url, data, opts) {
    return request(url, 'GET', data, opts);
  },
  post: function post(url, data, opts) {
    return request(url, 'POST', data, opts);
  },
  put: function put(url, data, opts) {
    return request(url, 'PUT', data, opts);
  },
  "delete": function _delete(url, data, opts) {
    return request(url, 'DELETE', data, opts);
  },
  patch: function patch(url, data, opts) {
    return request(url, 'PATCH', data, opts);
  }
};