"use strict";

var UTILS = {
  getQueryString: function getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return "";
  },
  copy: function copy(str) {
    var input = document.createElement("input");
    document.body.appendChild(input);
    input.setAttribute("value", str);
    input.select();
    document.execCommand("copy");
    document.body.removeChild(input);
  },
  checkIsLogin: function checkIsLogin() {
    return new Promise(function (resolve, reject) {
      $.ajax({
        url: "/api/v2/user/user-state",
        method: "post",
        headers: {
          "Content-Type": "application/json; charset=utf-8"
        }
      }).then(function (res) {
        console.log(res, "!!");
      }, function (errRes) {
        reject();
      });
    });
  },
  formatDate: function formatDate(targetDate, fmt) {
    if (!(targetDate instanceof Date)) {
      targetDate = new Date(targetDate);
    }
    // 对Date的扩展，将 Date 转化为指定格式的String
    // 月(M)、日(d)、小时(H)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
    // 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
    var o = {
      "M+": targetDate.getMonth() + 1,
      //月份
      "d+": targetDate.getDate(),
      //日
      "h+": targetDate.getHours(),
      //小时
      "m+": targetDate.getMinutes(),
      //分
      "s+": targetDate.getSeconds(),
      //秒
      "q+": Math.floor((targetDate.getMonth() + 3) / 3),
      //季度
      S: targetDate.getMilliseconds() //毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (targetDate.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o) if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
    return fmt;
  },
  delay: function delay(time) {
    return new Promise(function (ok) {
      setTimeout(ok, time);
    });
  },
  updateXlogParams: function updateXlogParams(obj) {
    window.xlog_params = Object.assign({}, Object.assign({}, window.xlog_params || {}), obj);
  },
  getDay: function getDay(time) {
    var date = new Date(time);
    date.setHours(0);
    date.setMinutes(0);
    date.setSeconds(0);
    return Math.floor(+date / 1000) * 1000;
  },
  createModal: function createModal(options) {
    //bodyClass,html
    var bodyClass = options.bodyClass || "";
    var div = document.createElement("div");
    var container = document.createElement("div");
    container.classList.add("chuanyu-modal-container");
    var body = document.createElement("div");
    body.classList.add("modal-body");
    if (bodyClass) {
      body.classList.add(bodyClass);
    }
    if (options.html) {
      body.innerHTML = options.html;
    }
    container.appendChild(body);
    div.appendChild(container);
    document.body.classList.add("ovh");
    var closeHandler = function closeHandler() {
      div.parentNode.removeChild(div);
      document.body.classList.remove("ovh");
      div = null;
    };
    document.body.appendChild(div);
    return closeHandler;
  }
};