"use strict";

if ("scrollRestoration" in history) {
  history.scrollRestoration = "manual";
} else {
  window.onunload = function () {
    window.scrollTo(0, 0);
  };
}
$(function () {
  var $typeDownloadBtn = $("#type-download-btn");
  function setDownloadBtn() {
    if (/windows/gi.test(navigator.userAgent)) {
      $typeDownloadBtn.text("Windows版下载");
      $typeDownloadBtn.off("click");
      $typeDownloadBtn.on("click", function () {
        window._downloadPackage('windows');
      });
    }
  }
  setDownloadBtn();
  $(".custom-header .home").addClass("active");
  var header = document.querySelector(".theme-header");
  $(window).on("scroll", function (e) {
    var st = $(window).scrollTop();
    if (st >= 886) {
      header.classList.remove("light");
    } else {
      header.classList.add("light");
    }
  });
  //更新弹框
  window._request.get("/api/v3/user/settings").then(function (res) {
    console.log(res);
    if (res.code == 0 && res.data) {
      var _res$data$kook_booste;
      if (res.data.global_notice_card && res.data.global_notice_card.enable) {
        if (!window.localStorage.getItem("checked_".concat(res.data.global_notice_card.id))) {
          openUpdateModal(res.data.global_notice_card);
        }
      }
      if (res.data.sad_gray_index) {
        document.body.style.filter = "grayscale(1)";
      }
      if ((_res$data$kook_booste = res.data.kook_booster_settings) !== null && _res$data$kook_booste !== void 0 && _res$data$kook_booste.download_url) {
        window.KOOK_BOOSTER_DOWNLOAD_URL = res.data.kook_booster_settings.download_url;
      }
    }
  })["catch"](function (e) {
    console.log("e", e);
  });
  function openUpdateModal(data) {
    var banners = data.banner || [];
    var bannerSrc = banners[0] || "";
    var contentHtml = "\n    <div class=\"upgrade-conent\">\n    <div class=\"title\">\u5F00\u9ED1\u5566\u7684\u65B0\u540D\u5B57\uFF1AKOOK</div>\n    <div class=\"section\">\u4ECE2019\u5E74\u5E74\u5E95\u5F00\u9ED1\u5566\u7B2C\u4E00\u7248\u6B63\u5F0F\u4E0A\u7EBF\uFF0C\u5230\u4ECA\u5929\u5168\u65B0\u7248\u672C\u5347\u7EA7\uFF0C\u90FD\u79BB\u4E0D\u5F00\u5927\u5BB6\u7684\u652F\u6301\u548C\u5E2E\u52A9\uFF0C\u6211\u4EEC\u611F\u6FC0\u4E0D\u5C3D! \u672A\u6765\u7684\u65E5\u5B50\u6211\u4EEC\u4F1A\u4EE5\u7EC8\u4E3A\u59CB\uFF0C\u4E0D\u8D1F\u5927\u5BB6\u7684\u671F\u5F85\u4E0E\u4FE1\u8D56\uFF0C\u8BA9KOOK\u6210\u4E3A\u4E00\u4E2A\u597D\u7528\u7684\u8BED\u97F3\u6C9F\u901A\u5DE5\u5177\u3002<br />Talk is cheap. Make it happen. </div>\n    <div class=\"kui-hr\"></div>\n    <div class=\"title\">\u548C\u4EE5\u524D\u76F8\u6BD4\uFF0C\u4F1A\u6709\u70B9\u4E0D\u540C\u7684\u5730\u65B9</div>\n    <div class=\"section\"><strong>+</strong> \u6211\u4EEC\u6539\u4E86\u4E2A\u540D\uFF0C\u53C8\u91CD\u65B0\u8BBE\u8BA1\u4E86\u70B9UI\u3002</div>\n    <div class=\"section\"><strong>+</strong> \u6211\u4EEC\u6362\u4E86\u4E2A\u5B98\u7F51\uFF1A<span class=\"app-kaihei-link\"><a target=\"_blank\" href=\"https://www.kookapp.cn/\">kookapp.cn</a></span>\u3002</div>\n    </div>\n    \n    ";
    var html = "\n    <div class=\"kook-update-modal-title\"><img src=\"".concat(bannerSrc, "\"></div>\n    <div class=\"first-newversion-body theme-scroll-bar\">").concat(contentHtml, "</div>\n    <div class=\"kook-confirm-footer absolute\">\n    <button class=\"chuanyu-button size-md type-primary\"><span id=\"confirmBtn\" class=\"button-text\">\u6211\u77E5\u9053\u4E86</span></button></div>\n    ");
    var closeHandler = UTILS.createModal({
      html: html,
      bodyClass: "kook-update-modal"
    });
    var $btn = $(".kook-update-modal #confirmBtn");
    var _clickHandler = function clickHandler() {
      closeHandler();
      window.localStorage.setItem("checked_".concat(data.id), 1);
      $btn.off("click", _clickHandler);
    };
    $btn.on("click", _clickHandler);
  }
});