/*!
* Tiny Carousel 1.9
* http://www.baijs.nl/tinycarousel
*
* Copyright 2010, Maarten Baijs
* Dual licensed under the MIT or GPL Version 2 licenses.
* http://www.opensource.org/licenses/mit-license.php
* http://www.opensource.org/licenses/gpl-2.0.php
*
* Date: 01 / 06 / 2011
* Depends on library: jQuery
*/

(function($) {
    $.tiny = $.tiny || {};

    $.tiny.carousel = {
        options: {
            start: 1, // where should the carousel start?
            axis: 'x', // vertical or horizontal scroller? ( x || y ).
            controls: true, // show left and right navigation buttons.
            pager: false, // is there a page number navigation present?
            interval: false, // move to another block on intervals.
            intervaltime: 3000, // interval time in milliseconds.
            rewind: false, // If interval is true and rewind is true it will play in reverse if the last slide is reached.
            animation: true, // false is instant, true is animate.
            duration: 1000, // how fast must the animation move in ms?
            animation_name: "fade",
            animation_stop_if_hover: true,
            callback: null, // function that executes after every move.
            customevent: null
        }
    };

    $.fn.tinycarousel = function(options) {
        var options = $.extend({}, $.tiny.carousel.options, options);
        this.each(function() { $(this).data('tcl', new Carousel($(this), options)); });
        return this;
    };
    $.fn.tinycarousel_start = function () { $(this).data('tcl').start(); };
    $.fn.tinycarousel_stop = function () { $(this).data('tcl').stop(); };
    $.fn.tinycarousel_move = function(iNum) { $(this).data('tcl').move(iNum - 1, true); };

    function Carousel(root, options) {
        var oSelf = this,
            oViewport = $('.viewport:first', root),
            oContent = $('.overview:first', root),
            oPages = oContent.children(),
            oBtnNext = $('.next:first', root),
            oBtnPrev = $('.prev:first', root),
            oPager = $('.pager:first', root),
            iPageSize,
            iSteps,
            iCurrent,
            oTimer,
            bPause;

        var bForward = true,
           colors = ["#4B53A4", "#4B93A4"];

        function initialize() {
            iSteps = oPages.length;
            iCurrent = Math.min(iSteps, Math.max(1, options.start)) - 1;

            if (!(options.animation && options.duration && options.animation_name === "slide")) {
                iPageSize = $(oPages[0]).outerWidth(true);
                oContent.css('width', iPageSize);

                for (var i = 0; i < iSteps; i++) {
                    if (iCurrent != i) {
                        $(oPages[i]).hide();
                    }
                }
            }

            oSelf.move(iCurrent, true);
            setEvents();
            return oSelf;
        };

        function setEvents() {
            if (options.controls && oBtnPrev.length > 0 && oBtnNext.length > 0) {
                oBtnPrev.on("click", function() {
                    if (oBtnPrev.hasClass("disable")) {
                        return false;
                    }
                    oSelf.move(-1);
                    return false;
                });
                oBtnNext.on("click", function() {
                    if (oBtnNext.hasClass("disable")) {
                        return false;
                    }
                    oSelf.move(1);
                    return false;
                });
            }
            if (options.interval && options.animation_stop_if_hover) { root.hover(oSelf.stop, oSelf.start); }
            if (options.pager && oPager.length > 0) { $('a', oPager).click(setPager); }
        };

        function setButtons() {
            if (options.controls && options.rewind === false) {
                oBtnPrev.toggleClass('disable', !(iCurrent > 0));
                oBtnNext.toggleClass('disable', !(iCurrent + 1 < iSteps));
            }
            if (options.pager) {
                var oNumbers = $('.pagenum', oPager);
                oNumbers.removeClass('active');
                $(oNumbers[iCurrent]).addClass('active');
            }
        };

        function setPager(oEvent) {
            if ($(this).hasClass('pagenum')) { oSelf.move(parseInt(this.rel), true); }
            return false;
        };

        function setTimer() {
            if (options.interval && !bPause) {
                clearTimeout(oTimer);
                oTimer = setTimeout(function() {

                    iCurrent = iCurrent + 1 == iSteps ? -1 : iCurrent;

                    bForward = iCurrent + 1 == iSteps ? false : iCurrent == 0 ? true : bForward;
                    oSelf.move(bForward ? 1 : -1);
                }, options.intervaltime);
            }
        };

        function execCustom() {
            if (typeof options.customevent == 'function') {
                options.customevent.call(oSelf, oPages[iCurrent], iCurrent);
            }
        };

        this.stop = function () { clearTimeout(oTimer); bPause = true; };
        this.start = function () { bPause = false; setTimer(); };
        this.move = function(iDirection, bPublic) {
            var $oldEl = {};
            if (options.rewind === true && iCurrent < 0) {
                $oldEl = $(oPages[iSteps - 1]);
            } else {
                $oldEl = $(oPages[iCurrent]);
            }
            iCurrent = bPublic ? iDirection : iCurrent += iDirection;

            if (options.rewind === true) {
                if (iCurrent < 0) {
                    iCurrent = iSteps - 1;
                }
                if (iCurrent + 1 > iSteps) {
                    iCurrent = 0;
                }
            }

            if (iCurrent > -1 && iCurrent < iSteps) {
                var $newEl = $(oPages[iCurrent]);

                if ($oldEl.length == 0 || $oldEl.is($newEl)) {//first time
                    execCustom();
                } else if (options.animation && options.duration && options.animation_name === "fade") {
                    $oldEl.fadeOut(options.duration, function () { execCustom(); });
                } else if (options.animation_name !== "slide") {
                    $oldEl.fadeOut(0, function () { execCustom(); });
                }

                if (options.animation_name === "slide") {
                    oContent.animate({ 'left': '-' + $newEl.position().left + 'px' }, function () {
                        if (typeof options.callback == 'function')
                            options.callback.call(this, oPages[iCurrent], iCurrent);
                    });
                } else {
                    $newEl
                        .delay(options.animation ? options.duration : 0)
                        .fadeIn(options.animation ? options.duration : 0,
                            function () { execCustom(); });
                }

                setButtons();
                setTimer();
            }
        };
        return initialize();
    };
})(jQuery);