﻿window.addEventListener('DOMContentLoaded', function() {
        selectRandom(".quote-placeholder > .item");
        
});

// HTML hero banner elements 
var headline = document.querySelector("#heroHeadline");
var subheadline = document.querySelector("#heroSubheadline");
var btn = document.querySelector("#heroBtn");
var mainImg = document.querySelector("#heroImg");
var mobileImg = document.querySelector("#heroImgMobile");
var dots = document.querySelectorAll(".dot");

// quote/author
var quoteText = document.querySelector(".quote")
var quoteAuthor = document.querySelector(".quoteAuthor")

// for mobile swipes
var slides = document.querySelector("#heroSlides");
let xStart = 0;
let xEnd = 0;

// add listener for touchstart
slides.addEventListener("touchstart", (e) => {
    xStart = e.changedTouches[0].screenX;
},{passive:true})

// add listener for touchend
slides.addEventListener("touchend", (e) => {
    xEnd = e.changedTouches[0].screenX;
    checkDirection();
})
// update banner on swipe
function checkDirection() {
    if (xStart < xEnd) {
        incrementDisplay(-1); 
    } if (xStart > xEnd) {
        incrementDisplay(1)
    }
}

// carousel timer declaration
var carouselTimer;

function restartCarouselTimer() {
    clearInterval(carouselTimer);
    carouselTimer = setInterval(updateBannerIndexOnInterval, intervalInMs);
}
function incrementDisplay(increment) {
    bannerIndex = ensureIndexIsInBounds(bannerIndex + increment, bannerList.length);    
    quoteIndex = ensureIndexIsInBounds(quoteIndex + increment, quoteList.length);
    updateDisplay(quoteIndex, bannerIndex)
}
function updateBannerIndexOnInterval() {
    incrementDisplay(1); 
}

// Set hero img
function setHeroImg(imgElement, defaultClass, newImg) {
    imgElement.className = `${defaultClass} ${newImg}`; 
}
function selectRandom(selector) {
    var elements = $(selector);
    var index = getRandom(0,elements.length);
    elements.eq(index).show();
}
function getRandom(min,max){
    return Math.floor((Math.random() * max) + min);
}

// assign banner properties to HTML elements
function renderCurrentBanner (item) {
    headline.innerHTML = item.Headline;
    subheadline.innerHTML = item.SubHeadline;
    btn.innerHTML = item.ButtonLabel;
    btn.href = item.ButtonLink;
    btn.setAttribute("target", item.LinkTarget);
    
    setHeroImg(mainImg, "homeHero", item.ImageClass);
    if (mobileImg !== null) setHeroImg(mobileImg, "mobileBanner show-on-small", item.ImageClass);
}
// function render current quote
function renderCurrentQuote (quote) {
    quoteText.innerHTML = quote.Quote;
    quoteAuthor.innerHTML = `- ${quote.Author}`;
}
function adjustQuoteIndexForDots(index) {
    let quotesLength = quoteList.length;
    let indexDifference =  quoteIndex + (index - bannerIndex);
   
    if (indexDifference === 0) return indexDifference;
    if (quotesLength <= indexDifference) {
        return indexDifference - quotesLength;
    }
    if (indexDifference < 0) {
        return quotesLength + indexDifference;
    }
    return indexDifference;
    
}
// set current banner from dots
function setCurrentBanner(index) {
    quoteIndex = adjustQuoteIndexForDots(index);
    bannerIndex = ensureIndexIsInBounds(index, bannerList.length);
    updateDisplay(quoteIndex, bannerIndex);
}

function updateDisplay(quoteIndex, bannerIndex) {
    renderCurrentQuote(quoteList[quoteIndex]);
    renderCurrentBanner(bannerList[bannerIndex]);
    renderCurrentDot();
    restartCarouselTimer();
}
function ensureIndexIsInBounds(index, arrLength) {
    // so nav will 'loop' through quotes & banners
    if (index > arrLength - 1) {return 0}    
    if (index < 0) {return arrLength -1}
    return index;
}

function renderCurrentDot() {
    // remove dot style for non-active banners
    dots.forEach(el=>{
        el.classList.remove("active");
    });
    
    // style for current banner dot 
    dots[bannerIndex].classList.add("active");
}
renderCurrentDot();
restartCarouselTimer();










